unit Fltdemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, Grids, DBGrids,
  StdCtrls, Buttons,
  UZFilter,
  DBIErrs;										{ used by TUZFilter1Exception }

type
  TForm1 = class(TForm)
	 Database1: TDatabase;
	 Table1: TTable;
	 DataSource1: TDataSource;
	 DBGrid1: TDBGrid;
	 UZFilter1: TUZFilter;
	 BitBtn2: TBitBtn;
	 Table2: TTable;
	 GroupBox1: TGroupBox;
	 CheckBox1: TCheckBox;
    DataSource2: TDataSource;
	 DBGrid2: TDBGrid;
    UZFilter2: TUZFilter;
    GroupBox2: TGroupBox;
	 CheckBox2: TCheckBox;
	 Table2OrderNo: TFloatField;
	 Table2CustNo: TFloatField;
	 Table2ItemsTotal: TCurrencyField;
	 Table2SaleDate: TDateTimeField;
	 Table2ShipDate: TDateTimeField;
	 function UZFilter1FilterRecord(Sender: TObject; RecNo: Longint;
		DataSet: TDataset): Boolean;
	 function UZFilter2FilterRecord(Sender: TObject; RecNo: Longint;
		DataSet: TDataset): Boolean;
	 procedure CheckBox1Click(Sender: TObject);
	 procedure CheckBox2Click(Sender: TObject);
	 procedure FormActivate(Sender: TObject);
	 procedure CheckBoxSetDisplay;
	 procedure UZFilter1FilterException(Sender: TObject; E: Exception);
  private
	 { Private declarations }
  public
	 { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{---------------------------------------------------------------------------
*  Here it is, the callback function used to filter the TTable/TDataSet
*
*  NOTE:		though it seems trivial, here is done something, which wouldn't
*				be possible with DELPHI renages/filtering, because the
*				FILTER-FIELD is NOT THE INDEXED FIILD
*
*	ALL YOU HAVE TO CODE IS THIS !!!
*
*---------------------------------------------------------------------------}
function TForm1.UZFilter1FilterRecord(Sender: TObject; RecNo: Longint;
										  DataSet: TDataset): Boolean;
begin
	Result := (DataSet.FieldByName('CustNo').AsInteger > 1500) and
				 (DataSet.FieldByName('CustNo').AsInteger < 2200);
end;

{---------------------------------------------------------------------------
*  this is the filter callback for the detail table ORDERS
*
*  NOTE:	->	the filters are INDEPENDANT from each other
*			->	if using a mastersourced (linked) DataSource, the DATAIL-checks
*				go HEREIN !!
*
*	ALL YOU HAVE TO CODE IS THIS !!!
*
*---------------------------------------------------------------------------}
function TForm1.UZFilter2FilterRecord(Sender: TObject; RecNo: Longint;
										  DataSet: TDataset): Boolean;
begin
	Result := (DataSet.FieldByName('ItemsTotal').AsInteger > 5000);
end;


{-----------------------------------------------------------------------------
*
* TForm1.UZFilter1FilterException:	a copy of the TUZfilter's default exception-
*								handler used here as a sample how to catch nasty
*								exceptions thrown bye BDE.
*
*		NEW w. V.1.07:		This handler is for demonstartion only. If you'd like to
*								add anything, just code it in.
*
*		NOTE:					As the following code is a genuine copy of TUZFilter's
*								DEFAULT execoption-catcher, you ONLY need to define/code
*								this routine, if you're going to replace that default
*								exception handler of a TUFilter in case exceptions occur,
*								that the default handler does not hanlde, but you would
*								like to track them down.
*
*	Purpose:					This exception-handler traps EOF/BOF exceptions, if BDE
*								and that's a bug, throws them, when hitting EOF/BOF of
*								a TUZFiltered TTable
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
*													see dcoumentation of
*													Application.OnException
* value:
*
*-----------------------------------------------------------------------------}
procedure TForm1.UZFilter1FilterException(Sender: TObject; E: Exception);
begin
	messagebeep(0);
	if E is EDBEngineError then begin					{ DBEngine-error ? }
		with EDBEngineError(E).Errors[0] do begin		{ get the recent error }
			if (ErrorCode = DBIERR_EOF) or 				{ EOF-error ? }
				(ErrorCode = DBIERR_BOF) then begin		{ BOF-error ? }
				;                          				{ just eat it }
			end else begin										{ ! NOT EOF }
				Application.ShowException(E);				{ just show the exception }
			end;													{ ? EOF/BOF }
		end;														{ with DBE-errorstack }
	end else begin												{ ! NO DBEngine-error }
		Application.ShowException(E);						{ just show the exception }
	end;															{ ? DBEngineError }
end;

{---------------------------------------------------------------------------
*  all the other stuff is just to get a proper outfit for the demo
*---------------------------------------------------------------------------}
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
	UZFilter1.Active := not(UZFilter1.Active);{ just switch the filter on/off }
	CheckBoxSetDisplay;								{ update diplay for CheckBoxes }
	{---------------------------------------------------------------------------
	*	you might try these, but before doing so, 'please examine the DBFILTUZ.INT
	*	CAREFULLY to check specially the security functions
	*---------------------------------------------------------------------------}
(*	DataSource1.DataSet.Active :=          	{ switch the dataset active-mode }
		not(DataSource1.DataSet.Active);			*)
(*	Table3.Active := true;       					{ switch to another table }
	DataSource1.DataSet := Table3;				{ NOTE: must add another TTable first !! }
															*)

(*	UZFilter1.DataSource := nil;					{ kill filter's datasource }
															*)
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
	UZFilter2.Active := not(UZFilter2.Active);{ just switch the filter on/off }
	CheckBoxSetDisplay;								{ update diplay for CheckBoxes }
end;

procedure TForm1.CheckBoxSetDisplay;
begin
	with CheckBox1 do begin							{ all on CheckBox1 }
		If UZFilter1.Active then begin			{ is the filter active ? }
			Caption := '1500 > CustNo < 2200';
			Font.Color := clLime;
			Checked := true;
		end else begin         						{ ! no inactive }
			Caption := 'inactive';
			Font.Color := clRed;
			Checked := false;
		end;												{ ? UZFilter2 active }
	end;													{ with CheckBox1 }
	with CheckBox2 do begin							{ all on CheckBox1 }
		If UZFilter2.Active then begin			{ is the filter active ? }
			Caption := 'ItemsTotal > 5000';
			Font.Color := clLime;
			Checked := true;
		end else begin         						{ ! no inactive }
			Caption := 'inactive';
			Font.Color := clRed;
			Checked := false;
		end;												{ ? UZFilter1 active }
	end;													{ with CheckBox1 }
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
	CheckBoxSetDisplay;								{ update display for CheckBoxes }
end;



end.
